/*
 * Decompiled with CFR 0.152.
 */
package de.jaret.util.ui.table.util.action;

import de.jaret.util.ui.table.JaretTable;
import de.jaret.util.ui.table.model.IColumn;
import de.jaret.util.ui.table.model.ITableViewState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ConfigureColumnsAction
extends Action {
    protected JaretTable _table;
    protected ITableViewState _tvs;
    protected CheckboxTableViewer _chkBoxViewer;
    protected List<IColumn> _saveOrder;
    protected Map<IColumn, Boolean> _saveVisibility;
    protected boolean _allowFixedColumns;

    public ConfigureColumnsAction(JaretTable table, boolean allowFixedColumns) {
        this.setTable(table);
        this._allowFixedColumns = allowFixedColumns;
    }

    public ConfigureColumnsAction(JaretTable table) {
        this(table, true);
    }

    public void setTable(JaretTable table) {
        this._table = table;
        this._tvs = this._table.getTableViewState();
    }

    public void run() {
        this.save();
        Dialog confColsDialog = new Dialog(Display.getCurrent().getActiveShell()){

            protected Control createDialogArea(Composite parent) {
                return ConfigureColumnsAction.this.createColumnControlPanel(parent);
            }
        };
        int result = confColsDialog.open();
        if (result == 1) {
            this.restore();
        }
    }

    private void save() {
        this._saveOrder = new ArrayList<IColumn>();
        this._saveOrder.addAll(this._tvs.getSortedColumns());
        this._saveVisibility = new HashMap<IColumn, Boolean>();
        for (int i = 0; i < this._table.getTableModel().getColumnCount(); ++i) {
            IColumn col = this._table.getTableModel().getColumn(i);
            this._saveVisibility.put(col, this._tvs.getColumnVisible(col));
        }
    }

    private void restore() {
        this._tvs.setSortedColumns(this._saveOrder);
        for (int i = 0; i < this._table.getTableModel().getColumnCount(); ++i) {
            IColumn col = this._table.getTableModel().getColumn(i);
            boolean visible = this._saveVisibility.get(col);
            this._tvs.setColumnVisible(col, visible);
        }
    }

    public String getText() {
        return "Configure columns";
    }

    private Control createColumnControlPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new RowLayout());
        Label l = new Label(panel, 0);
        l.setText("Configure the columns");
        Table table = new Table(parent, 68130);
        this._chkBoxViewer = new CheckboxTableViewer(table);
        this._chkBoxViewer.setContentProvider((IContentProvider)new ColTableContentProvider());
        this._chkBoxViewer.setLabelProvider((IBaseLabelProvider)new ColTableLabelProvider());
        TableColumn column = new TableColumn(this._chkBoxViewer.getTable(), 16384);
        column.setText("Column");
        column.setWidth(100);
        this._chkBoxViewer.getTable().setHeaderVisible(true);
        this._chkBoxViewer.setInput((Object)"x");
        final int firstColIdx = this._allowFixedColumns ? 0 : this._table.getFixedColumns();
        for (int i = 0; i < this._table.getTableModel().getColumnCount(); ++i) {
            IColumn col = this._table.getTableModel().getColumn(i);
            this._chkBoxViewer.setChecked((Object)col, this._tvs.getColumnVisible(col));
        }
        table.getColumn(0).pack();
        table.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 32) {
                    TableItem item = (TableItem)event.item;
                    IColumn col = (IColumn)item.getData();
                    int idx = ConfigureColumnsAction.this._tvs.getSortedColumns().indexOf(col);
                    if (ConfigureColumnsAction.this._allowFixedColumns || idx >= ConfigureColumnsAction.this._table.getFixedColumns()) {
                        ConfigureColumnsAction.this._tvs.setColumnVisible(col, item.getChecked());
                    } else {
                        ConfigureColumnsAction.this._chkBoxViewer.setChecked((Object)col, ConfigureColumnsAction.this._tvs.getColumnVisible(col));
                    }
                }
            }
        });
        Button upButton = new Button(panel, 8);
        upButton.setText("up");
        upButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (ConfigureColumnsAction.this._chkBoxViewer.getTable().getSelectionCount() > 0) {
                    TableItem item = ConfigureColumnsAction.this._chkBoxViewer.getTable().getItem(ConfigureColumnsAction.this._chkBoxViewer.getTable().getSelectionIndex());
                    IColumn col = (IColumn)item.getData();
                    int idx = ConfigureColumnsAction.this._tvs.getSortedColumns().indexOf(col);
                    if (idx > firstColIdx) {
                        ConfigureColumnsAction.this._tvs.getSortedColumns().remove(col);
                        ConfigureColumnsAction.this._tvs.getSortedColumns().add(idx - 1, col);
                        ConfigureColumnsAction.this._table.updateColumnList();
                        ConfigureColumnsAction.this._table.redraw();
                        ConfigureColumnsAction.this._chkBoxViewer.refresh();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        Button downButton = new Button(panel, 8);
        downButton.setText("down");
        downButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                if (ConfigureColumnsAction.this._chkBoxViewer.getTable().getSelectionCount() > 0) {
                    TableItem item = ConfigureColumnsAction.this._chkBoxViewer.getTable().getItem(ConfigureColumnsAction.this._chkBoxViewer.getTable().getSelectionIndex());
                    IColumn col = (IColumn)item.getData();
                    int idx = ConfigureColumnsAction.this._tvs.getSortedColumns().indexOf(col);
                    if (idx < ConfigureColumnsAction.this._tvs.getSortedColumns().size() - 1) {
                        ConfigureColumnsAction.this._tvs.getSortedColumns().remove(col);
                        ConfigureColumnsAction.this._tvs.getSortedColumns().add(idx + 1, col);
                        ConfigureColumnsAction.this._table.updateColumnList();
                        ConfigureColumnsAction.this._table.redraw();
                        ConfigureColumnsAction.this._chkBoxViewer.refresh();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        return panel;
    }

    public class ColTableLabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object obj, int i) {
            String result;
            IColumn column = (IColumn)obj;
            int idx = ConfigureColumnsAction.this._tvs.getSortedColumns().indexOf(column);
            switch (i) {
                case 0: {
                    result = column.getHeaderLabel();
                    if (ConfigureColumnsAction.this._allowFixedColumns || idx >= ConfigureColumnsAction.this._table.getFixedColumns()) break;
                    result = result + "(fixed)";
                    break;
                }
                default: {
                    result = "error - unknow column";
                }
            }
            return result;
        }

        public void addListener(ILabelProviderListener ilabelproviderlistener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object obj, String s) {
            return false;
        }

        public void removeListener(ILabelProviderListener ilabelproviderlistener) {
        }

        public Image getColumnImage(Object arg0, int arg1) {
            return null;
        }
    }

    public class ColTableContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object element) {
            Object[] kids = null;
            List<IColumn> l = ConfigureColumnsAction.this._table.getTableViewState().getSortedColumns();
            kids = l.toArray();
            return kids;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldObject, Object newObject) {
        }
    }
}

