/*
 *  File: ITableNodeListener.java 
 *  Copyright (c) 2004-2007  Peter Kliem (Peter.Kliem@jaret.de)
 *  A commercial license is available, see http://www.jaret.de.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Common Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/cpl-v10.html
 */
package de.jaret.util.ui.table.model;

/**
 * Interface for listening on jaret table nodes in a hierarchical model.
 * 
 * @author Peter Kliem
 * @version $Id: ITableNodeListener.java 179 2007-01-07 17:37:50Z olk $
 */
public interface ITableNodeListener {
    /**
     * Called when a node has been added.
     * 
     * @param parent Parent of the new node.
     * @param newChild the new node.
     */
    void nodeAdded(ITableNode parent, ITableNode newChild);

    /**
     * Called whenever a node is removed.
     * 
     * @param parent parent of the removed node.
     * @param removedChild the removed node.
     */
    void nodeRemoved(ITableNode parent, ITableNode removedChild);
}
